/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei.transfer;

import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.core.AELog;
import appeng.core.localization.ItemModText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.FillCraftingGridFromRecipePacket;
import appeng.integration.modules.jei.transfer.AbstractTransferHandler;
import appeng.menu.AEBaseMenu;
import appeng.menu.me.common.GridInventoryEntry;
import appeng.menu.me.common.MEStorageMenu;
import appeng.menu.me.items.CraftingTermMenu;
import appeng.util.CraftingRecipeUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.crafting.IShapedRecipe;

public class UseCraftingRecipeTransfer<T extends CraftingTermMenu>
extends AbstractTransferHandler
implements IRecipeTransferHandler<T, CraftingRecipe> {
    private static final int BLUE_SLOT_HIGHLIGHT_COLOR = 0x400000FF;
    private static final int RED_SLOT_HIGHLIGHT_COLOR = 0x66FF0000;
    private static final int BLUE_PLUS_BUTTON_COLOR = -2142943745;
    private static final int ORANGE_PLUS_BUTTON_COLOR = -2130729728;
    private static final Comparator<GridInventoryEntry> ENTRY_COMPARATOR = Comparator.comparing(GridInventoryEntry::getStoredAmount);
    private final Class<T> containerClass;
    private final IRecipeTransferHandlerHelper helper;

    public UseCraftingRecipeTransfer(Class<T> containerClass, IRecipeTransferHandlerHelper helper) {
        this.containerClass = containerClass;
        this.helper = helper;
    }

    public IRecipeTransferError transferRecipe(T menu, CraftingRecipe recipe, IRecipeLayout display, Player player, boolean maxTransfer, boolean doTransfer) {
        if (recipe.m_6671_() != RecipeType.f_44107_) {
            return this.helper.createInternalError();
        }
        if (recipe.m_7527_().isEmpty()) {
            return this.helper.createUserErrorWithTooltip((Component)ItemModText.INCOMPATIBLE_RECIPE.text());
        }
        if (!recipe.m_8004_(3, 3)) {
            return this.helper.createUserErrorWithTooltip((Component)ItemModText.RECIPE_TOO_LARGE.text());
        }
        boolean craftMissing = AbstractContainerScreen.m_96637_();
        Map<Integer, Ingredient> slotToIngredientMap = UseCraftingRecipeTransfer.getGuiSlotToIngredientMap(recipe);
        CraftingTermMenu.MissingIngredientSlots missingSlots = ((CraftingTermMenu)menu).findMissingIngredients(UseCraftingRecipeTransfer.getGuiSlotToIngredientMap(recipe));
        if (missingSlots.missingSlots().size() == slotToIngredientMap.size()) {
            return this.helper.createUserErrorForSlots((Component)ItemModText.NO_ITEMS.text(), missingSlots.missingSlots());
        }
        if (!doTransfer) {
            if (missingSlots.totalSize() != 0) {
                return new ErrorRenderer((CraftingTermMenu)menu, (Recipe<?>)recipe);
            }
        } else {
            this.performTransfer(menu, (Recipe<?>)recipe, craftMissing);
        }
        return null;
    }

    protected void performTransfer(T menu, Recipe<?> recipe, boolean craftMissing) {
        NonNullList<ItemStack> templateItems = this.findGoodTemplateItems(recipe, (MEStorageMenu)menu);
        ResourceLocation recipeId = recipe.m_6423_();
        if (((AEBaseMenu)((Object)menu)).getPlayer().f_19853_.m_7465_().m_44043_(recipe.m_6423_()).isEmpty()) {
            AELog.debug("Cannot send recipe id %s to server because it's transient", recipeId);
            recipeId = null;
        }
        NetworkHandler.instance().sendToServer(new FillCraftingGridFromRecipePacket(recipeId, templateItems, craftMissing));
    }

    private NonNullList<ItemStack> findGoodTemplateItems(Recipe<?> recipe, MEStorageMenu menu) {
        Map<AEKey, Integer> ingredientPriorities = this.getIngredientPriorities(menu, ENTRY_COMPARATOR);
        NonNullList templateItems = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
        NonNullList<Ingredient> ingredients = CraftingRecipeUtil.ensure3by3CraftingMatrix(recipe);
        for (int i = 0; i < ingredients.size(); ++i) {
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            if (ingredient.m_43947_()) continue;
            ItemStack stack = ingredientPriorities.entrySet().stream().filter(e -> {
                AEItemKey itemKey;
                Object patt6095$temp = e.getKey();
                return patt6095$temp instanceof AEItemKey && ingredient.test((itemKey = (AEItemKey)patt6095$temp).toStack());
            }).max(Comparator.comparingInt(Map.Entry::getValue)).map(e -> ((AEItemKey)e.getKey()).toStack()).orElse(ingredient.m_43908_()[0]);
            templateItems.set(i, (Object)stack);
        }
        return templateItems;
    }

    private static Map<Integer, Ingredient> getGuiSlotToIngredientMap(Recipe<?> recipe) {
        int height;
        int width;
        NonNullList ingredients = recipe.m_7527_();
        if (recipe instanceof IShapedRecipe) {
            IShapedRecipe shapedRecipe = (IShapedRecipe)recipe;
            width = shapedRecipe.getRecipeWidth();
            height = shapedRecipe.getRecipeHeight();
        } else if (ingredients.size() > 4) {
            height = 3;
            width = 3;
        } else if (ingredients.size() > 1) {
            height = 2;
            width = 2;
        } else {
            height = 1;
            width = 1;
        }
        HashMap<Integer, Ingredient> result = new HashMap<Integer, Ingredient>(ingredients.size());
        for (int i = 0; i < ingredients.size(); ++i) {
            int guiSlot = 1 + UseCraftingRecipeTransfer.getCraftingIndex(i, width, height);
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            if (ingredient.m_43947_()) continue;
            result.put(guiSlot, ingredient);
        }
        return result;
    }

    private static int getCraftingIndex(int i, int width, int height) {
        int index;
        if (width == 1) {
            index = height == 3 ? i * 3 + 1 : (height == 2 ? i * 3 + 1 : 4);
        } else if (height == 1) {
            index = i + 3;
        } else if (width == 2) {
            index = i;
            if (i > 1) {
                ++index;
                if (i > 3) {
                    ++index;
                }
            }
        } else {
            index = height == 2 ? i + 3 : i;
        }
        return index;
    }

    public Class<T> getContainerClass() {
        return this.containerClass;
    }

    public Class<CraftingRecipe> getRecipeClass() {
        return CraftingRecipe.class;
    }

    private record ErrorRenderer(CraftingTermMenu menu, Recipe<?> recipe) implements IRecipeTransferError
    {
        public IRecipeTransferError.Type getType() {
            return IRecipeTransferError.Type.COSMETIC;
        }

        public void showError(PoseStack poseStack, int mouseX, int mouseY, IRecipeLayout recipeLayout, int recipeX, int recipeY) {
            boolean craftMissing = AbstractContainerScreen.m_96637_();
            CraftingTermMenu.MissingIngredientSlots missingSlots = this.menu.findMissingIngredients(UseCraftingRecipeTransfer.getGuiSlotToIngredientMap(this.recipe));
            ArrayList<Component> extraTooltip = new ArrayList<Component>();
            if (missingSlots.anyCraftable()) {
                if (craftMissing) {
                    extraTooltip.add((Component)ItemModText.WILL_CRAFT.text().m_130940_(ChatFormatting.BLUE));
                } else {
                    extraTooltip.add((Component)ItemModText.CTRL_CLICK_TO_CRAFT.text().m_130940_(ChatFormatting.BLUE));
                }
            }
            if (missingSlots.anyMissing()) {
                extraTooltip.add((Component)ItemModText.MISSING_ITEMS.text().m_130940_(ChatFormatting.RED));
            }
            IGuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
            Map ingredients = itemStackGroup.getGuiIngredients();
            for (Map.Entry entry : ingredients.entrySet()) {
                int i = (Integer)entry.getKey();
                boolean missing = missingSlots.missingSlots().contains(i);
                boolean craftable = missingSlots.craftableSlots().contains(i);
                if (!missing && !craftable) continue;
                ((IGuiIngredient)entry.getValue()).drawHighlight(poseStack, missing ? 0x66FF0000 : 0x400000FF, recipeX, recipeY);
            }
            ErrorRenderer.drawHoveringText(poseStack, extraTooltip, mouseX, mouseY);
        }

        public static void drawHoveringText(PoseStack poseStack, List<Component> textLines, int x, int y) {
            Minecraft minecraft = Minecraft.m_91087_();
            Font font = minecraft.f_91062_;
            ErrorRenderer.drawHoveringText(poseStack, textLines, x, y, ItemStack.f_41583_, font);
        }

        private static void drawHoveringText(PoseStack poseStack, List<Component> textLines, int x, int y, ItemStack itemStack, Font font) {
            Minecraft minecraft = Minecraft.m_91087_();
            Screen screen = minecraft.f_91080_;
            if (screen == null) {
                return;
            }
            Optional tooltipImage = itemStack.m_150921_();
            screen.renderTooltip(poseStack, textLines, tooltipImage, x, y, font, itemStack);
        }
    }
}

